#version 330
#extension GL_EXT_gpu_shader4 : enable
//Octahedralis IIMod01.fsh by sl2c
//https://www.shadertoy.com/view/wdSyDG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Copyright 2020 Google LLC
// SPDX-License-Identifier: Apache-2.0
// NOT an official Google project; see Google Open Source guidelines for more info on copyright transfer
// written by William Cadegan-Schlieper 
float s = 0.4142135623730951; // silver ratio

void octant1(inout vec2 z, inout float ds, inout vec3[3] colors) {
    if (z.x < 0.0) {
        z.x = -z.x;
        colors[2]=1.0-colors[2];
    }
    if (z.y < 0.0) {
        z.y = -z.y;
        colors[1]=1.0-colors[1];
    }
    float r2 = dot(z,z);
    if (r2 > 1.0) {
        z /= r2; ds /= r2;
        colors[0]=1.0-colors[0];
    }
}

vec3 color(vec2 z, float ds, bool fl) {
    vec3[3] colors;
    colors[0]=vec3(1.0,0.5,0.0);
    colors[1]=vec3(0.0,1.0,0.5);
    colors[2]=vec3(0.5,0.0,1.0);
    
    if (fl) {
        colors[0]=1.0-colors[0];
        colors[1]=1.0-colors[1];
        colors[2]=1.0-colors[2];
    }
    
    float r2;
    int n = 60;
    int i;
    for(i=0;i<n;i++) {
        octant1(z, ds, colors);
        z -= vec2(s,s);
        r2 = dot(z,z);
        if (r2 < s * s) {
            z *= s * s / r2; ds *= s * s / r2;
            fl = !fl;
            z += vec2(s,s);
        } else {
            z += vec2(s,s);
        	break;
        }
    }
    octant1(z, ds, colors);
    r2 = dot(z,z);
    float v = (r2 - 2.0 * (z.x + z.y) * s + s * s) / (2.0 * ds * s * s);
    v = min(v,1.0);
    v = 0.75 + 0.25 * float(n-i) / float(n) * v;
    if (fl) v = 1.5 - v;
    float zz = 0.5 * (1.0 - r2);
    if (zz > z.x && zz > z.y) {
        return colors[0] * v * min(1.0, min((zz - z.x) / ds, (zz - z.y) / ds));
    }
    if (z.y > z.x) {
        return colors[1] * v * min(1.0, min((z.y - zz) / ds, (z.y - z.x) / ds));
    }
    return colors[2] * v * min(1.0, min((z.x - zz) / ds, (z.x-z.y) / ds));
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
{
    vec2 uv = 2.0 * (gl_FragCoord.xy - iResolution.xy * 0.5)/iResolution.y;
    float ds = 4.0 / iResolution.y;
    
    float period = 4.2549485065150545;
    float t = iTime * 0.5;
    bool r = false;
    
    while (t > period * 0.5) {
        t -= period;
        float c = 0.766311365; float s = -0.64246936;
        uv = vec2(uv.x * c - uv.y * s, uv.x * s + uv.y * c);
        r = !r;
    }
    
    uv *= exp(-t); ds *= exp(-t);
    
    uv += vec2(0.25262046414724887,-1.0187347727326157);
	uv /= dot(uv,uv); ds *= dot(uv,uv);
    uv += vec2(0.22732631827540598,0.4228686518338363);

    gl_FragColor = vec4(color(uv,ds,r),1.0);
    gl_FragColor = pow(gl_FragColor, vec4(1./2.2));
}
